package gov.va.med.mhv.mrp.webservice;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskSearchDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.common.dto.MyTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyTaskSearchDTO;

@Path("/")
@Service
public interface MyGoalsWebService {
	
	@POST
	@Path("/mygoal/task/search/{userProfileId}")	
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public MyTaskSearchDTO getMyGoalsTaskByName(@PathParam("userProfileId") Long userProfileId, MyTaskSearchDTO myTaskSearchDTO);
	
	@GET
	@Path("/mygoals/{userProfileId}")	
	@Produces(MediaType.APPLICATION_JSON)
	public List<MyGoalDTO> getMyGoalsForUser(@PathParam("userProfileId") Long userProfileId);
	
	@GET
	@Path("/mygoals/completed/{userProfileId}")	
	@Produces(MediaType.APPLICATION_JSON)
	public List<MyGoalDTO> getMyCompletedGoalsForUser(@PathParam("userProfileId") Long userProfileId);
	
	@GET
	@Path("/mygoal/{userProfileId}/{goalId}")	
	@Produces(MediaType.APPLICATION_JSON)
	public MyGoalDTO getMyGoalById(@PathParam("userProfileId") Long userProfileId, @PathParam("goalId") Long goalId);

	@POST
	@Path("/mygoal/goalname/{userProfileId}")	
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public MyGoalDTO getMyGoalByName(@PathParam("userProfileId") Long userProfileId, String goalName);
	
	@POST
	@Path("/mygoal/{userProfileId}")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public MyGoalDTO saveMyGoal(@PathParam("userProfileId") Long userProfileId, MyGoalDTO myGoalDTO);
	
	@DELETE
	@Path("/mygoal/{userProfileId}/{goalId}")
	public Response deleteMyGoal(@PathParam("userProfileId") Long userProfileId, @PathParam("goalId") Long goalId);
		
	@POST
	@Path("/mygoal/tasks")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public List<MyTaskDTO> getMyGoalTasksForUser (MyGoalTaskSearchDTO myGoalTaskSearchDTO);//create new DTO for date range

	@POST
	@Path("/mygoal/tasks/keyword")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public List<MyTaskDTO> getMyGoalTasksByKeyword (MyGoalTaskSearchDTO myGoalTaskSearchDTO);//create new DTO for date range

	@GET
	@Path("/mygoal/extension/{goalExtensionId}")	
	@Produces(MediaType.APPLICATION_JSON)
	public MyGoalsExtensionDTO getMyGoalsExtension(@PathParam("goalExtensionId") Long goalExtensionId);
	
	@POST
	@Path("/mygoal/extension/{goalId}")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public MyGoalsExtensionDTO addMyGoalsExtension(@PathParam("goalId") Long goalId, MyGoalsExtensionDTO myGoalsExtensionDTO);

	@DELETE
	@Path("/mygoal/extension/{goalExtensionId}")
	public Response deleteMyGoalsExtension(@PathParam("goalExtensionId") Long goalExtensionId);

	@POST
	@Path("/mygoal/task/{goalExtensionId}")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public MyGoalTaskDTO addMyGoalTask(@PathParam("goalExtensionId") Long goalExtensionId, MyGoalTaskDTO myGoalTaskDTO);
	
	@DELETE
	@Path("/mygoal/task/{taskId}")
	public Response deleteMyGoalTask(@PathParam("taskId") Long taskId);
	

}
